//%attributes = {}
// Method: pr_ AmountStock1ToStock2
// 2005.09.08-16:13:18 / ME
// © Copyright 2005 Manage Applications
// Purpose: Converts amount from stock unit 1 to stock unit 2
// 
// ------------------------------------------------------------
C_REAL:C285($0; $1; $2)
C_LONGINT:C283($3)  //round value to default decimals
C_REAL:C285($pr_rStock1Amount; $pr_rStock2Amount; $pr_rMultiplier)

$pr_rStock1Amount:=$1
$pr_rMultiplier:=$2

If ($pr_rMultiplier=kGet)  //-10022
	Case of 
		: (_sel RecsInSel(pr_kTbl)<=0) & (_fi RecNew=kFalse) & (_rec Loaded(pr_kTbl)=kFalse)
			// Modified by: MG_PM 2013-06-18, added & (_fi RecNew =kFalse)
			
			//AK: 2008-05-05
			_err MESSAGE(_lang Current("Product is not selected, conversion multiplier can not be loaded"); Current method name:C684; kTrue)
			
		: (_rec Loaded(pr_kTbl)=kFalse)
			_err MESSAGE(_lang Current("Product record is not loaded, conversion multiplier can not be loaded"); Current method name:C684; kTrue)
			
		Else 
			$pr_rMultiplier:=_fld ValueReal(pr_kConversion_Multiplier)
	End case 
End if 

Case of 
	: ($pr_rMultiplier=0)
		$pr_rStock2Amount:=0
	: ($pr_rMultiplier#-1)
		// from unit 1 to unit 2 we need to divide  
		$pr_rStock2Amount:=$pr_rStock1Amount/$pr_rMultiplier
	Else   //-1 = inverse number
		If ($pr_rStock1Amount#0)
			$pr_rStock2Amount:=1/$pr_rStock1Amount
		Else 
			$pr_rStock2Amount:=0
		End if 
End case 

If ($3=kTrue)
	$pr_rStock2Amount:=Round:C94($pr_rStock2Amount; <>pr_iPyörMäär)
End if 
$0:=$pr_rStock2Amount
